//--------------------------------------------------------------------------------------- 
//  FILE:    X2Effect_RemoveViperBind_LEBPsi
//  AUTHOR:  LeaderEnemyBoss
//  PURPOSE: makes sure that viper bind gets removed properly and only once per snuggle pair
//--------------------------------------------------------------------------------------- 

class X2Effect_RemoveViperBind_RMPsi extends X2Effect;

//`include(PsiOverhaul_LEB\Src\LEBPsiAbilities.uci)

var privatewrite name LEBBindRemoved;

simulated protected function OnEffectAdded(const out EffectAppliedData ApplyEffectParameters, XComGameState_BaseObject kNewTargetState, XComGameState NewGameState, XComGameState_Effect NewEffectState)
{
	local XComGameState_Effect EffectState;
	local X2Effect_Persistent PersistentEffect;
	local XComGameState_Unit EffectSource, EffectTarget;
	local UnitValue LEBBindValueSource, LEBBindValueTarget;

	//`LEBMSG("============================================================");
	//`LEBMSG("X2Effect_RemoveViperBind_LEBPsi OnEffectAdded");

	foreach `XCOMHISTORY.IterateByClassType(class'XComGameState_Effect', EffectState)
	{
		PersistentEffect = EffectState.GetX2Effect();

		//If (PersistentEffect.EffectName == class'X2Ability_Viper'.default.BindSustainedEffectName || PersistentEffect.EffectName == class'X2AbilityTemplateManager'.default.BoundName)
		If (PersistentEffect.EffectName == class'X2Ability_Viper'.default.BindSustainedEffectName)
		{
			If (EffectState.ApplyEffectParameters.SourceStateObjectRef.ObjectID == ApplyEffectParameters.TargetStateObjectRef.ObjectID || EffectState.ApplyEffectParameters.TargetStateObjectRef.ObjectID == ApplyEffectParameters.TargetStateObjectRef.ObjectID )
			{
				EffectSource = XComGameState_Unit(`XCOMHISTORY.GetGameStateForObjectID(EffectState.ApplyEffectParameters.SourceStateObjectRef.ObjectID));
				EffectTarget = XComGameState_Unit(`XCOMHISTORY.GetGameStateForObjectID(EffectState.ApplyEffectParameters.TargetStateObjectRef.ObjectID));
				
				EffectTarget.GetUnitValue(default.LEBBindRemoved, LEBBindValueTarget);
				
				//`LEBMSG("X2Effect_RemoveViperBind_LEBPsi" @EffectState.ObjectID @EffectState.bRemoved @PersistentEffect.EffectName @EffectSource.GetFullName() @LEBBindValueSource.fValue @EffectTarget.GetFullName() @LEBBindValueTarget.fValue);

				If (LEBBindValueSource.fValue < 1.0f && LEBBindValueTarget.fValue < 1.0f)
				{
					EffectState.RemoveEffect(NewGameState, NewGameState, true);

					EffectSource.SetUnitFloatValue(default.LEBBindRemoved, 2.0f, eCleanup_BeginTactical);
					EffectTarget.SetUnitFloatValue(default.LEBBindRemoved, 2.0f, eCleanup_BeginTactical);
				}
			}
		}
	}
}

DefaultProperties
{
	LEBBindRemoved = "LEBBindRemoved"
}